/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.item;

import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.item.BlockMutatorBehaviour;
import compasses.expandedstorage.impl.item.EntityInteractableItem;
import compasses.expandedstorage.impl.item.MutationMode;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StorageMutator
extends Item
implements EntityInteractableItem {
    public StorageMutator(Item.Properties settings) {
        super(settings);
    }

    public static MutationMode getMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("mode", 1)) {
            tag.m_128344_("mode", (byte)0);
        }
        return MutationMode.from(tag.m_128445_("mode"));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        BlockMutatorBehaviour behaviour = CommonMain.getBlockMutatorBehaviour(state.m_60734_(), StorageMutator.getMode(stack));
        if (behaviour != null) {
            ToolUsageResult returnValue = behaviour.attempt(context, level, state, pos, stack);
            if (returnValue.getResult().m_19080_()) {
                context.m_43723_().m_36335_().m_41524_((Item)this, returnValue.getDelay());
            }
            return returnValue.getResult();
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41784_();
            MutationMode nextMode = StorageMutator.getMode(stack).next();
            tag.m_128344_("mode", nextMode.toByte());
            if (tag.m_128441_("pos")) {
                tag.m_128473_("pos");
            }
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237110_((String)("tooltip.expandedstorage.storage_mutator.description_" + nextMode), (Object[])new Object[]{Utils.ALT_USE}), true);
            }
            player.m_36335_().m_41524_((Item)this, 5);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        StorageMutator.getMode(stack);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        StorageMutator.getMode(stack);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag context) {
        MutationMode mode = StorageMutator.getMode(stack);
        list.add((Component)Component.m_237110_((String)"tooltip.expandedstorage.storage_mutator.tool_mode", (Object[])new Object[]{Component.m_237115_((String)("tooltip.expandedstorage.storage_mutator." + mode))}).m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237110_((String)("tooltip.expandedstorage.storage_mutator.description_" + mode), (Object[])new Object[]{Utils.ALT_USE}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public InteractionResult es_interactEntity(Level level, Entity entity, Player player, InteractionHand hand, ItemStack stack) {
        EntityConversionRecipe<?> recipe;
        MutationMode mode = StorageMutator.getMode(stack);
        if (mode == MutationMode.SWAP_THEME && (recipe = ConversionRecipeManager.INSTANCE.getEntityRecipe(entity, stack)) != null) {
            InteractionResult result = recipe.process(level, player, stack, entity);
            if (result.m_19080_()) {
                player.m_36335_().m_41524_((Item)this, 20);
            }
            return result;
        }
        return InteractionResult.FAIL;
    }
}

